 ; Ŀ
 ;   Rash - make existing rev triangles match the rev in the tb.           
 ;   Rt - install a rev triangle.                                          
 ;   Copyright 2002, 2007 - 2010 by Rocket Software Ltd.                   
 ;   Subroutines aren't necessarily better code, they're just easier       
 ;   to cut and paste.                                                     
 ; 

 ; Ŀ
 ;   Baka - find the latest rev in a title block.                          
 ;   Allows for similar revision name tags.                                
 ;   Arguments: Blnam, the title block name.                               
 ;              Tagbas, the base tag name.                                 
 ;              Taglen, the tag name length.                               
 ;   Returns a string or nil if there are no inserts or revs.              
 ;                                                                         
 ;   Is that wise?  Should we quit on a title block but no revs?           
 ;   But why would someone try to update revs then?  And it is unlikely    
 ;   that there would be two different rev blocks.                         
 ;   What about two of the same rev block?  Hard to predict.               
 ;   If one is empty then use the other?  Or flag an error?  But this is   
 ;   probably going to be used during a batch.                             
 ; 
 (DEFUN BAKA (blnam tagbas taglen / ss len enam revsav entt val tagg stop)
  (if (setq ss (ssget "x" (list (cons 2 blnam) (cons 66 1))))
      (progn
           (setq len (strlen tagbas))
           (setq enam (ssname ss 0))
           (while (and (null stop)
                       (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                               (entnext enam)))))) "SEQEND"))
                  (setq val (cdr (assoc 1 entt)))
                  (setq tagg (cdr (assoc 2 entt)))
                  (cond ((and (= (strcase (substr tagg 1 len))
                                 (strcase tagbas))
                              (= (strlen tagg) taglen)
                              (member val '("" " " "  " "-" "_" "..." ".")))
                         (setq stop t))
                        ((and (= (strcase (substr tagg 1 len))
                                 (strcase tagbas))
                              (= (strlen tagg) taglen))
                         (setq revsav val))))))
 revsav)
 ; Ŀ
 ;   Baka end.                                                             
 ; 

 ; Ŀ
 ;   Bdor - find the latest rev in a Gc_a1_titleblock.                     
 ;   Takes no arguments.                                                   
 ;   Returns a string which will be empty if there are no revs             
 ;   and nil if there was no tb.                                           
 ; 
 (DEFUN BDOR (/ ss enam entt val tagg stop projo revo)
  (if (and (tblsearch "block" "GC_A1_TITLEBLOCK")
           (setq ss (ssget "X" (list (cons 2 "GC_A1_TITLEBLOCK") (cons 66 1)))))
      (progn
           (setq enam (ssname ss 0))
           (while (and (null stop)
                       (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                                 (entnext enam)))))) "SEQEND"))
                  (setq val (cdr (assoc 1 entt)))
                  (setq tagg (cdr (assoc 2 entt)))
                  (cond ((= tagg "TBPROJ")
                         (setq projo val))
                        ((= tagg "TBREV")
                         (setq revo val)
                         (setq stop t))))))
 (if (and projo revo) (strcat projo "-" revo)))
 ; Ŀ
 ;   Bdor end.                                                             
 ; 

 ; Ŀ
 ;   Blik - get a point for block insertion with block ghosting.           
 ;   This won't ghost if the block has a wipeout over the outline.         
 ;   Arguments: Blnam, a block name.                                       
 ;              Scal, the insertion scale.                                 
 ;              Rota, the insertion angle.                                 
 ;   Calls nothing, returns a point.                                       
 ; 
 (DEFUN BLIK (blnam scal rota / attr prenam enam pa)
  (setq attr (getvar "attreq"))
  (setvar "attreq" 0)
  (setq prenam (entlast))
  (write-line "\nInsertion Point: ")
  (command "insert" blnam "s" scal "r" rota)
  (command pause)
  (setvar "attreq" attr)
  (setq enam (entlast))
  (if (/= enam prenam)
      (progn
           (setq pa (cdr (assoc 10 (entget enam))))
           (entdel enam)))
 pa)
 ; Ŀ
 ;   Blik end.                                                             
 ; 

 ; Ŀ
 ;   Bora1 - find the latest rev in a strange Bor_a1 title block.          
 ;   The rev in the tb is an encapsulated lamicoid block.  The Rev         
 ;   attributes have different prompts but the same tags.                  
 ;   Arguments: None.                                                      
 ;   Returns a string or nil if there are no revs or no Bord_a1 inserts.   
 ; 
 (DEFUN BORA1 (/ ss enam revsav entt val tagg stop)
  (if (setq ss (ssget "x" (list (cons 2 "bord_a1") (cons 66 1))))
      (progn
           (setq enam (ssname ss 0))
           (while (and (null stop)
                       (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                               (entnext enam)))))) "SEQEND"))
                  (setq val (cdr (assoc 1 entt)))
                  (setq tagg (cdr (assoc 2 entt)))
                  (cond ((and (= tagg "REV#")
                              (member val '("" " " "  " "-" "_" "..." ".")))
                         (setq stop t))
                        ((= tagg "REV#")
                         (setq revsav val))))))
 revsav)
 ; Ŀ
 ;   Bora1 end.                                                            
 ; 

 ; Ŀ
 ;   Brevor - find the main rev in a Tridyne_tb_d title block.             
 ;   Takes no arguments.                                                   
 ;   Returns a string or nil if no Tridyne tb was found.                   
 ; 
 (DEFUN BREVOR (/ ss enam tagg entt stop)
  (if (setq ss (ssget "X" (list (cons 2 "tridyne_tb_d") (cons 66 1))))
      (progn
           (setq enam (ssname ss 0))
 ; Ŀ
 ;   Step through the title block.                                         
 ;   Find the main rev while we're at it.                                  
 ; 
           (while (not stop)
                  (setq tagg (cdr (assoc 2 (setq entt (entget (setq enam
                                                           (entnext enam)))))))
                  (if (= tagg "REVISION")
                      (setq stop (cdr (assoc 1 entt)))))))
 stop)
 ; Ŀ
 ;   Brevor end.                                                           
 ; 

 ; Ŀ
 ;   Debor - find the latest rev in a D-Bord-E title block.                
 ;   Takes no arguments.                                                   
 ;   Returns a string which will be empty if there are no revs             
 ;   and nil if there was no tb.                                           
 ; 
 (DEFUN DEBOR (/ revsav ss enam entt val tagg stop)
  (if (setq ss (ssget "X" (list (cons 2 "D-Bord-E") (cons 66 1))))
      (progn
           (setq enam (ssname ss 0))
           (while (and (null stop)
                       (/= (cdr (assoc 0 (setq entt (entget (setq enam
                                                 (entnext enam)))))) "SEQEND"))
                  (setq val (cdr (assoc 1 entt)))
                  (setq tagg (cdr (assoc 2 entt)))
                  (cond ((and (member tagg
                               '("R1" "R2" "R3" "R4" "R5" "R6" "R7" "R8" "R9"))
                              (member val '("" " " "  " "-" "..." ".")))
                         (setq stop t))
                        ((member tagg
                               '("R1" "R2" "R3" "R4" "R5" "R6" "R7" "R8" "R9"))
                         (setq revsav val))))
           (if (null revsav) (setq revsav ""))))
 revsav)
 ; Ŀ
 ;   Debor end.                                                            
 ; 

 ; Ŀ
 ;   Frevor - find the value of the first attribute with a given tag name. 
 ;   Arguments: Blnam, the name of the block.                              
 ;              Tagnam, the tag name.                                      
 ;   Returns a string or nil if no block or no attribute was found.        
 ; 
 (DEFUN FREVOR (blnam tagnam / ss enam tagg entt stop)
  (if (setq ss (ssget "X" (list (cons 2 blnam) (cons 66 1))))
      (progn
           (setq enam (ssname ss 0))
 ; Ŀ
 ;   Find the attribute.                                                   
 ; 
           (while (not stop)
                  (setq tagg (cdr (assoc 2 (setq entt (entget (setq enam
                                                           (entnext enam)))))))
                  (if (= (strcase tagg) (strcase tagnam))
                      (setq stop (cdr (assoc 1 entt)))))))
 stop)
 ; Ŀ
 ;   Frevor end.                                                           
 ; 

 ; Ŀ
 ;   Grench - get the latest rev from an Encana title block rev area.      
 ;   Arguments: Enam - the tb ename.                                       
 ;   Returns the line number of the new rev (as a string).                 
 ; 
 (DEFUN GRENCH (enam / esav entt tagg tval revlon descr)
 ; Ŀ
 ;   Find the line number of the first empty date.                         
 ; 
  (while (and (null revlon)
              (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext
                                                         enam)))))) "SEQEND"))
         (setq tagg (cdr (assoc 2 entt)))
         (setq tval (cdr (assoc 1 entt)))
         (if (and (= (substr tagg 1 (1- (strlen tagg))) "RDATE")
                  (member tval (list "-" "." " " "" "  ")))
             (setq revlon (substr tagg (strlen tagg)))))
 ; Ŀ
 ;   Deduce the current rev letter.                                        
 ; 
  (setq descr (chr (+ (read revlon) 63)))
 descr)
 ; Ŀ
 ;   Grench end.                                                           
 ; 

 ; Ŀ
 ;   Layp - see if a layer is off, locked, or frozen.                      
 ;   Takes one argument, a layer name.                                     
 ;   Returns a list of conditions or nil                                   
 ; 
 (DEFUN LAYP (lanam / llist sev col stalst)
  (setq llist (tblsearch "layer" lanam))
  (setq sev (cdr (assoc 70 llist)))
  (setq col (cdr (assoc 62 llist)))
  (if (= (logand sev 1) 1) (setq stalst (list "frozen")))
  (if (= (logand sev 4) 4) (setq stalst (cons "locked" stalst)))
  (if (minusp col) (setq stalst (cons "off" stalst)))
 stalst)
 ; Ŀ
 ;   Layp end.                                                             
 ; 

 ; Ŀ
 ;   Rash - find a title block, extract the rev.                           
 ;   Takes no arguments, Calls numerous other things.                      
 ;   Returns a string or nil if no tb was found.                           
 ; 
 (DEFUN RASH (/ reva ss enam num)
  (if (not (or (setq reva (debor))   ; d-bord-e
               (setq reva (bora1))   ; bord_a1
               (setq reva (brevor))  ; Tridyne_tb_d
               (setq reva (rema))    ; cnrl tb text
               (setq reva (bdor))    ; gemini Gc_a1_titleblock
 ; Ŀ
 ;   Baka extracts revs from blocks with Rev1, rev2, rev3 etc. names.      
 ;   The Exergy Revs stub block has a rev attribute but it isn't always    
 ;   right.                                                                
 ;   We should look for Stub tbs first since they usually precede the      
 ;   main ones.                                                            
 ;   Baka is probably a better subroutine to use than Frevor because       
 ;   The main tb isn't always made to match the rev line if revs are       
 ;   added by hand.                                                        
 ; 
               (setq reva (baka "exergy revs" "rev#_" 6))
               (setq reva (baka "shawn" "rev#" 4))
               (setq reva (baka "tcmtb" "rev#_" 6))
 ; Ŀ
 ;   Frevor searches for an attribute by name in a block by name and is    
 ;   probably the best method when the attribute has a unique name or      
 ;   is the first attribute by that name and the rev is contained in a     
 ;   single attribute: i.e. almost always except with Encana.              
 ; 
               (setq reva (frevor "8.5x11 title block" "rev#_dwg"))
               (setq reva (frevor "border" "rev"))
               (setq reva (frevor "bord_a4" "rev_#"))
               (setq reva (frevor "cardtbk2" "rev"))
               (setq reva (frevor "nclttld1" "rev"))
               (setq reva (frevor "nclttld" "rev"))
               (setq reva (frevor "paramount_ENG3_tb" "revno"))
               (setq reva (frevor "pel d size" "rev#_dwg"))
               (setq reva (frevor "PEL D Size(Color)" "rev#_dwg"))
               (setq reva (frevor "PennWest TB_D Size-MS" "rev"))
               (setq reva (frevor "ppc-dsize" "rev#"))
               (setq reva (frevor "Provident TB D Size" "rev#_dwg"))
               (setq reva (frevor "RWTitleBlock" "rev#_dwg"))
               (setq reva (frevor "wec dsize metric" "rev_no"))
               (setq reva (frevor "new pel d size" "rev#_dwg"))
               (setq reva (trash))))    ; various encana - call last: slowest
      (prompt "No title block found."))
 reva)
 ; Ŀ
 ;   Subroutine Rash end.                                                  
 ; 

 ; Ŀ
 ;   Rema - find the rev in a CNRL title block.                            
 ;   Takes no arguments.                                                   
 ;   Returns a string or nil if no tb was found.                           
 ; 
 (DEFUN REMA (/ ss enam entt rev)
 ; Ŀ
 ;   Find the main title block.                                            
 ; 
  (if (setq ss (ssget "X" (list (cons 2 "cnrl tb text") (cons 66 1))))
      (progn
           (setq enam (ssname ss 0))
 ; Ŀ
 ;   Find the first rev attribute.                                         
 ; 
           (repeat 12 (setq enam (entnext enam)))
           (setq rev (cdr (assoc 1 (entget enam))))))
 rev)
 ; Ŀ
 ;   Rema end.                                                             
 ; 

 ; Ŀ
 ;   Slege - find the lowest (latest) rev line in a Pcp title block.       
 ;   Takes one argument, the tb ename.                                     
 ;   Returns the ename of the rev number attribute on the last line which  
 ;   contains a rev.                                                       
 ;   Since some title blocks have Projects without a date and numbers      
 ;   without a project, (Pcp/Encana being a bit of a moving target)        
 ;   it is assumed that any line with a project description is real.       
 ; 
 (DEFUN SLEGE (enam / entt tagg tval crev prerev revsav stop)
  (while (and (null stop)
              (/= (cdr (assoc 0 (setq entt (entget (setq enam (entnext
                                                         enam)))))) "SEQEND"))
         (setq tagg (cdr (assoc 2 entt)))
         (setq tval (cdr (assoc 1 entt)))
 ; Ŀ
 ;   Save each Rev number as it goes by.                                   
 ; 
         (if (= (substr tagg 1 (1- (strlen tagg))) "REV")
             (setq crev enam))
 ; Ŀ
 ;   Find the last attribute containing a Rev Description.                 
 ; 
         (cond ((and (= (substr tagg 1 (1- (strlen tagg))) "DESC")
                     (not (member tval (list "-" "." "" " " "  "))))
                (setq revsav crev))
               ((= (substr tagg 1 (1- (strlen tagg))) "DESC")
                (setq stop t))))
 revsav)
 ; Ŀ
 ;   Slege end.                                                            
 ; 

 ; Ŀ
 ;   Trach - update the rev number in a rev triangle.                      
 ;   Arguments: Enam, the tb ename.                                        
 ;              Newrev, the new rev string.                                
 ;   Returns nothing.                                                      
 ; 
 (DEFUN TRACH (enam newrev / entt)
  (setq entt (entget (entnext enam)))
  (entmod (subst (cons 1 newrev) (assoc 1 entt) entt))
  (entupd enam)
 (princ))
 ; Ŀ
 ;   Trach end.                                                            
 ; 

 ; Ŀ
 ;   Trash - find the latest rev in an Encana title block.                 
 ;   Takes no arguments.                                                   
 ;   Calls Slege and Grench.                                               
 ;   Returns a string which will be empty if there are no revs             
 ;   and nil if there was no tb.                                           
 ; 
 (DEFUN TRASH (/ ss enam revno projno projnm newrev)
 ; Ŀ
 ;   There are three identical PanCanadian TBs.                            
 ;   No: there are now (at least) four - T2A is new, and probably          
 ;   similar enough to the others for this routine to work.                
 ;   If not then this is the place to start debugging.                     
 ;   Later: we are now up to 5, and the name is Encana.  Mister Encana.    
 ; 
  (if (or (setq ss (ssget "X" (list (cons 2 "T-A002A"))))
          (setq ss (ssget "X" (list (cons 2 "REPL-A1"))))
          (setq ss (ssget "X" (list (cons 2 "T2A-3"))))
          (setq ss (ssget "X" (list (cons 2 "T2A"))))
          (setq ss (ssget "X" (list (cons 2 "PCPA1")))))
      (progn
           (setq enam (ssname ss 0))
 ; Ŀ
 ;   Get the revision letter.                                              
 ; 
           (setq revno (grench enam))
 ; Ŀ
 ;   Call slege to get the number of the latest Project line.              
 ; 
           (setq projnm (slege enam))
           (setq projno (cdr (assoc 1 (entget projnm))))
 ; Ŀ
 ;   Make the new rev number.                                              
 ; 
           (setq newrev (strcat projno revno))))
 newrev)
 ; Ŀ
 ;   Trash end.                                                            
 ; 

 ; Ŀ
 ;   Rt.                                                                   
 ; 
 (DEFUN C:RT (/ attr attd clay osmo snapp dimscl *error* reva revisp laset pa
                                                                       revstr)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq attr (getvar "attreq"))
  (setq attd (getvar "attdia"))
  (setq clay (getvar "clayer"))
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 1)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq dimscl (misps))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "attreq" attr)
   (setvar "attdia" attd)
   (setvar "clayer" clay)
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Call Rash to get a rev if there is a known tb in the drawing.         
 ; 
  (if (null (setq reva (rash)))
      (setq reva "A"))
 ; Ŀ
 ;   Save the current layer name, make Revision the new current one if     
 ;   it isn't locked or frozen or off, make it if it doesn't exist.        
 ; 
  (if (setq revisp (tblsearch "layer" "revise"))
      (setq laset (layp "revise")))
  (cond ((and revisp (null laset))
         (setvar "clayer" "revise"))
        ((null laset)
         (command "layer" "m" "revise" "c" "5" "" ""))
        (laset
         (prompt (strcat "The Revise layer is " (car laset) "."))))
 ; Ŀ
 ;   Call blik to get an insertion point.                                  
 ; 
  (setq pa (blik "revtri" dimscl "0"))
 ; Ŀ
 ;   Get a string, offering the rev from the tb (if any) as the default.   
 ; 
  (if (= "" (setq revstr (getstring (strcat "Rev <" reva ">: "))))
      (setq revstr reva))
  (setvar "attdia" 0)
  (command ".insert" "revtri" pa dimscl dimscl 0 revstr)
  (*error* nil)
 (princ))

 ; Ŀ
 ;   Rash - make rev triangles match the main TB rev.                      
 ;   Rocket - soothing the itchy parts of Cad.                             
 ; 
 (DEFUN C:RASH (/ reva ss enam num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Call Rash to get a rev if there is a known tb in the drawing.         
 ; 
  (if (setq reva (rash))
      (progn
 ; Ŀ
 ;   Find the rev triangles.                                               
 ; 
           (setq ss (ssget "X" (list (cons 2 "rev,revision,revtri")
                                     (cons 66 1))))
 ; Ŀ
 ;   And update them.                                                      
 ; 
           (while (and ss (setq enam (ssname ss
                                      (setq num (if (null num) 0 (1+ num))))))
                  (trach enam reva))))
  (command "undo" "end")
 (princ))